unit ucCategories;

interface

uses SysUtils, System.Data, System.Drawing, System.Web, System.Web.UI, System.Text, Borland.Data.Provider, Borland.Data.Common,
     System.Web.UI.WebControls, System.Web.UI.HtmlControls, SmartDataGrid;
     
type
    /// <summary>
    /// Summary description for WebUserControl1.
    /// </summary>
  TucCategories = class(System.Web.UI.UserControl)
  {$REGION 'Designer Managed Code'}
  strict private
    procedure InitializeComponent;
    procedure AddCatButton_Click(sender: System.Object; e: System.EventArgs);
    procedure DG_EditCommand(source: System.Object; e: System.Web.UI.WebControls.DataGridCommandEventArgs);
    procedure DG_CancelCommand(source: System.Object; e: System.Web.UI.WebControls.DataGridCommandEventArgs);
    procedure DG_UpdateCommand(source: System.Object; e: System.Web.UI.WebControls.DataGridCommandEventArgs);
    procedure DG_DeleteCommand(source: System.Object; e: System.Web.UI.WebControls.DataGridCommandEventArgs);
  {$ENDREGION}
  strict private
    procedure Page_Load(sender: System.Object; e: System.EventArgs);
  strict protected
    dlSubMenu: System.Web.UI.WebControls.DataList;
    ErrorMessage: System.Web.UI.WebControls.Label;
    LabelCategory: System.Web.UI.WebControls.Label;
    TextBoxCategory: System.Web.UI.WebControls.TextBox;
    AddCatButton: System.Web.UI.WebControls.Button;
    CategoryRequired: System.Web.UI.WebControls.RequiredFieldValidator;
    DG: SmartDataGrid.TSmartDataGrid;
    procedure OnInit(e: System.EventArgs); override;
  private
    procedure FixCategoryAdding(const CanAdd : boolean);

  public
    { Public Declarations }
  end;

implementation

uses HelperDB;

procedure TucCategories.Page_Load(sender: System.Object; e: System.EventArgs);
var
  selSQL : StringBuilder;
begin

	selSQL := StringBuilder.Create;
  selSQL.Append('SELECT COUNT(Products.CategoryID) AS ProductCount, ');
  selSQL.Append('Categories.CategoryID, Categories.CategoryName ');
  selSQL.Append('FROM Products RIGHT OUTER JOIN Categories ');
  selSQL.Append('ON Products.CategoryID = Categories.CategoryID ');
  selSQL.Append('GROUP BY Categories.CategoryID, Categories.CategoryName ');
  selSQL.Append('ORDER BY Categories.CategoryName');


  DG.AutoGenerateColumns:=False;
  DG.PageSize:=15;
  DG.AllowPaging := True;

  DG.SelectSQL := selSQL.ToString;

  DG.ErrorLabel := ErrorMessage;
  DG.DataKeyField := 'CategoryID';
  DG.DeleteSQL := 'DELETE FROM Categories WHERE CategoryID = ';

  if not page.IsPostBack then DG.BindData;
end;

procedure TucCategories.OnInit(e: System.EventArgs);
begin
  //
  // Required for Designer support
  //
  InitializeComponent;
  inherited OnInit(e);
end;

{$REGION 'Designer Managed Code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TucCategories.InitializeComponent;
begin
  Include(Self.AddCatButton.Click, Self.AddCatButton_Click);
  Include(Self.DG.EditCommand, Self.DG_EditCommand);
  Include(Self.DG.CancelCommand, Self.DG_CancelCommand);
  Include(Self.DG.UpdateCommand, Self.DG_UpdateCommand);
  Include(Self.DG.DeleteCommand, Self.DG_DeleteCommand);
  Include(Self.Load, Self.Page_Load);
end;
{$ENDREGION}


procedure TucCategories.AddCatButton_Click(sender: System.Object; e: System.EventArgs);
var
  insertSQL : string;
begin
  //if (CategoryRequired.IsValid) then
  begin
      insertSQL := 'INSERT INTO Categories (CategoryName) VALUES (' + QuotedStr(Server.HtmlEncode(TextBoxCategory.Text)) + ')';
      ErrorMessage.Text := THelperDB.InsertRecord(insertSQL);
      DG.BindData;
      TextBoxCategory.Text := '';
  end;
end; (*AddCatButton_Click*)


procedure TucCategories.FixCategoryAdding(const CanAdd: boolean);
begin
  CategoryRequired.Enabled := CanAdd;
  AddCatButton.Enabled := CanAdd;
end;

procedure TucCategories.DG_DeleteCommand(source: System.Object; e: System.Web.UI.WebControls.DataGridCommandEventArgs);
begin
  //nothing
end;

procedure TucCategories.DG_UpdateCommand(source: System.Object; e: System.Web.UI.WebControls.DataGridCommandEventArgs);
var
  catID, catName: string;
begin

  catID := DG.DataKeys[e.Item.ItemIndex].ToString();
  catName := TextBox(e.Item.FindControl('CategoryName')).Text;

  DG.UpdateSQL := 'UPDATE Categories SET CategoryName = ' + QuotedStr(catName) +' Where CategoryID = ' + catID;

  FixCategoryAdding(True);
end;

procedure TucCategories.DG_CancelCommand(source: System.Object; e: System.Web.UI.WebControls.DataGridCommandEventArgs);
begin
  FixCategoryAdding(True);
end;

procedure TucCategories.DG_EditCommand(source: System.Object; e: System.Web.UI.WebControls.DataGridCommandEventArgs);
begin
  FixCategoryAdding(False);
end; (*FixCategoryAdding*)


end.
